def send_update_state(client, map_id):
    payload = {
        "action": "update_state",
        "data": {
            "map_id": map_id,
        }
    }
    client.send_json(payload)

def send_loot_action(client, target_id):
    """Send a request to loot a target."""
    payload = {
        "action": "loot",
        "data": {
            "target_id": target_id
        }
    }
    client.send_json(payload)

def send_character_action(client, action_type, extra_data=None):
    """Send any character action that the server should handle (attack, use, loot, etc.)"""
    if not hasattr(client, "char_id") or client.char_id is None:
        print("[!] Missing client.char_id, cannot send action")
        return

    data = {"char_id": client.char_id}
    if extra_data:
        data.update(extra_data)

    payload = {
        "action": action_type,
        "data": data
    }
    client.send_json(payload)

def send_attack(client, target_id, player_pos=None, player_direction=None):
    """
    Send an attack command to the server.
    Includes current position and direction for debugging sync issues.
    """
    data = {"target_id": target_id}
    if player_pos:
        data["position"] = player_pos
    if player_direction:
        data["direction"] = player_direction
    
    client.send_json({
        "action": "attack",
        "data": data
    })
