import pygame
import os
from client.src.npc import NPC
from client.resource_path import get_resource_path

def npc_folder(npc_name):
    return get_resource_path(os.path.join("client", "assets", "images", "NPCs", npc_name))

def get_map_filename():
    return "sydney.tmx"

def on_player_enter_tile(player, tile_props):
    pass

def get_map_npcs():
    npc_group = pygame.sprite.Group()
    # Define NPCs with initial positions, actions, and scale
    Alex = NPC(1610, 868, {
        "idle": {"path": os.path.join(npc_folder("Alex"), "idle.png"), "frame_count": 2, "total_rows": 4, "frame_duration": 500, "skip_rows": [0, 1, 2]},
        "walk": {"path": os.path.join(npc_folder("Alex"), "walk.png"), "frame_count": 9, "total_rows": 4, "frame_duration": 200, "skip_rows": [0, 1, 2]},
    }, scale=2.65, direction="right")
    Alex.set_movement_queue([
    {
        "type": "repeat",
        "instructions": [
            {"type": "wait", "duration": 5000, "action": "idle", "direction": "left"},
            {"type": "wait", "duration": 12000, "action": "idle", "direction": "right"},
            {"type": "move", "target_x": 2000, "speed": 2, "action": "walk", "direction": "right"},
            {"type": "wait", "duration": 10000, "action": "idle", "direction": "left"},
            {"type": "wait", "duration": 7000, "action": "idle", "direction": "right"},
            {"type": "wait", "duration": 2000, "action": "idle", "direction": "left"},
            {"type": "move", "target_x": 1610, "speed": 2, "action": "walk", "direction": "left"},
        ]}
])
    
    # Set click handler for Alex
    def on_alex_click(npc):
        print(f"Alex was double-clicked at position ({npc.x}, {npc.y})")
        # Play sound effect
        try:
            sound_path = get_resource_path(os.path.join("client", "assets", "sounds", "npc","Alex", "alex_greeting.mp3"))
            sound = pygame.mixer.Sound(sound_path)
            sound.play()
        except pygame.error as e:
            print(f"Failed to play sound: {e}")
    
    Alex.set_on_click(on_alex_click)

    # Add NPCs to group
    npc_group.add(Alex)
    return npc_group