# client/src/camera.py
import pygame
from client.data import config

class Camera:
    def __init__(self, map_width, map_height):
        self.offset = pygame.Vector2(0, 0)
        self.smoothed_y = 0
        self.vertical_shift = 450
        self.map_width = map_width
        self.map_height = map_height
        self.initialized = False

    def update(self, player):
        # Use the BASE resolution from config or hardcoded
        screen_w, screen_h = 1920, 1080  # or from config.BASE_WIDTH / BASE_HEIGHT if defined

        target_x = int(player.x - screen_w / 2)
        target_y = int(player.y + player.collision_height - screen_h / 2 - self.vertical_shift)

        if not self.initialized:
            self.smoothed_y = target_y
            self.initialized = True
        else:
            self.smoothed_y += (target_y - self.smoothed_y) * 0.1

        # Clamp based on the *virtual* screen size
        max_x = self.map_width - screen_w
        max_y = self.map_height - screen_h + self.vertical_shift

        cam_x = max(0, min(target_x, max_x))
        cam_y = max(0, min(int(self.smoothed_y), max_y))

        self.offset.update(cam_x, cam_y)



    def apply(self, pos):
        """Offset a (x, y) position by the camera offset."""
        return (pos[0] - self.offset.x, pos[1] - self.offset.y)
